number exposure		= 1
number binning		= 1
number Time         = 1
number tilt         = 4		// tilt angle in mrad ( recommended value= 1Gl/sch )
number fs1       = -16		// first focus step in nm
number fs2		= -26		// second focus step in nm
string folder, name, projectName		// ### added by ki
number nmPerDAC, mradPerDAC		// ### added by ki
number defocusOffset = 0;	// ### added by ky 07/04/17
number centerDefocus = 0;	// ### added by ky 08/06/03

number top = 0, left = 0, bottom, right
number isSetup = 0;
number is2byte = 0;
String group = "TSR";
// ### Get camera sizes
SSCGetSize(right, bottom)	// (width, height)

// ### Get necessary parameters from Global Tags
// ### exposure, binning, time, fs1, nmPerDAC, tilt, mradPerDAC, folder, dataName
{
	TagGroup tag = GetPersistentTagGroup();
	Number   succeed;
	succeed = tag.TagGroupGetTagAsTagGroup( group, tag );
	if ( !succeed ) Exit( 0 );
	succeed = tag.TagGroupGetTagAsTagGroup( "Acquisition", tag );
	if ( !succeed ) Exit( 0 );

	tag.TagGroupGetTagAsString( "name", name );
	tag.TagGroupGetTagAsNumber( "exposure", exposure );
	tag.TagGroupGetTagAsNumber( "defocueOffset", defocusOffset );
	tag.TagGroupGetTagAsNumber( "centerDefocus", centerDefocus );
	tag.TagGroupGetTagAsNumber( "fs", fs1 );
	tag.TagGroupGetTagAsNumber( "tilt", tilt );
	tag.TagGroupGetTagAsNumber( "isSetup", isSetup );
	tag.TagGroupGetTagAsNumber( "is2byte", is2byte );
	tag.TagGroupGetTagAsString( "folder", folder );
	tag.TagGroupGetTagAsNumber( "nmPerDAC", nmPerDAC );
	tag.TagGroupGetTagAsNumber( "time", time );
	tag.TagGroupGetTagAsNumber( "binning", binning );
	tag.TagGroupGetTagAsNumber( "mradPerDAC", mradPerDAC );
}

projectName = folder + name;
bottom /= binning; right /= binning
fs1 /= nmPerDAC
fs2 = fs1*(sqrt(5)+1)*0.5	// #### ki
tilt /= mradPerDAC

number tiltx = 0, tilty=0, focus = (centerDefocus-defocusOffset)/nmPerDAC
number tx1 = tilt,		ty1= 0
number tx2 =-tilt,		ty2= 0
number tx3 = 0.5*tilt,		ty3= 0.866*tilt
number tx4 =-0.5*tilt,		ty4=-0.866*tilt
number tx5 =-0.5*tilt,		ty5= 0.866*tilt
number tx6 = 0.5*tilt,		ty6=-0.866*tilt
number ni=27
number n,n1
Image newimage
image img3D
imagedisplay disp3D
number width, height
EMChangeFocus(focus) // ### added by ky 07/04/18
for (n=1; n<=ni; n++)
{
	newimage := SSCGainNormalizedBinnedAcquire(exposure,binning,top, left, bottom, right)
	if ( is2byte ) {
		newimage.ConvertToShort();
	}
	if ( isSetup ) {
		if ( !img3D.ImageIsValid() ) {
			number type = newimage.GetDataType();
			newimage.GetSize(width, height);
			img3D := NewImage(name, type, width, height, ni);
			img3D.ShowImage();
			disp3D = img3D.ImageGetImageDisplay(0);
		}
		img3D[0, 0, n-1, width, height, n] = newimage;
		disp3D.ImageDisplaySetDisplayedLayers(n-1, n-1);
		img3D.UpdateImage();
	} else {
		showImage( newimage )
	}
	n1 = n+100
	//if (tilt<1000) saveAsGatan(newimage, projectName + "\\tilt0"+tilt+"im" + n1 + ".dm3")
	//if (tilt>=1000) saveAsGatan(newimage, projectName + "\\tilt"+tilt+"im" + n1 + ".dm3")
	saveAsGatan(newimage, projectName + "\\image" + n1 + ".dm3")
	delay(Time*60)
	Result("Image" + n1 + ", focus: " + focus + ", tiltx: " + tiltx + ", tilty: " + tilty+"\n")
	if (GetKey() == 27)
	{
		Result("Image acquisition aborted, restoring original settings")
		EMChangeFocus(-focus)
		focus = 0
		delay(Time*60)
		EMChangeTilt(-tiltx,-tilty)
		tiltx=0; tilty=0
		Result("Original settings restored")
		OkDialog("Image acquisition aborted, original settings restored")
		break
	}


if (n== 1) {EMChangeFocus( fs1); 	focus += fs1;}
if (n== 2) {EMChangeFocus( fs2); 	focus += fs2;}
if (n== 3) {EMChangeTilt(tx1,ty1); 	tiltx=tx1; tilty=ty1;}
if (n== 4) {EMChangeFocus(-fs2); 	focus -= fs2;}
if (n== 5) {EMChangeFocus(-fs1); 	focus -= fs1;}
if (n== 6) {EMChangeTilt(-tx1,-ty1); 	tiltx=0; tilty=0;}
if (n== 7) {EMChangeTilt(tx2,ty2); 	tiltx=tx2; tilty=ty2;}
if (n== 8) {EMChangeFocus( fs1); 	focus += fs1;}
if (n== 9) {EMChangeFocus( fs2); 	focus += fs2;}
if (n==10) {EMChangeTilt(-tx2,-ty2); 	tiltx=0; tilty=0;}
if (n==11) {EMChangeTilt(tx3,ty3); 	tiltx=tx3; tilty=ty3;}
if (n==12) {EMChangeFocus(-fs2); 	focus -= fs2;}
if (n==13) {EMChangeFocus(-fs1); 	focus -= fs1;}
if (n==14) {EMChangeTilt(-tx3,-ty3); 	tiltx=0; tilty=0;}
if (n==15) {EMChangeTilt(tx4,ty4); 	tiltx=tx4; tilty=ty4;}
if (n==16) {EMChangeFocus( fs1); 	focus += fs1;}
if (n==17) {EMChangeFocus( fs2); 	focus += fs2;}
if (n==18) {EMChangeTilt(-tx4,-ty4); 	tiltx=0; tilty=0;}
if (n==19) {EMChangeTilt(tx5,ty5); 	tiltx=tx5; tilty=ty5;}
if (n==20) {EMChangeFocus(-fs2); 	focus -= fs2;}
if (n==21) {EMChangeFocus(-fs1); 	focus -= fs1;}
if (n==22) {EMChangeTilt(-tx5,-ty5); 	tiltx=0; tilty=0;}
if (n==23) {EMChangeTilt(tx6,ty6); 	tiltx=tx6; tilty=ty6;}
if (n==24) {EMChangeFocus( fs1); 	focus += fs1;}
if (n==25) {EMChangeFocus( fs2); 	focus += fs2;}
if (n==26) {EMChangeTilt(-tx6,-ty6); 	tiltx=0; tilty=0;}

}
delay(Time*60)
EMChangeFocus(-focus)
delay(Time*60)
EMChangeTilt(-tiltx,-tilty)
Result("Finished. Original settings restored")

if ( isSetup ) {
        // Acquire Images command searchs the stacked image from the front most image.
        img3D.ShowImage();
}

Exit(1); // succeed
